"""AI that controls the enemy goals"""

import random

import serge.actor
from theme import G, theme

class AI(serge.actor.Actor):
    """Controls the enemies"""

    def __init__(self, tag, name, board, smartness):
        """Initialise the AI"""
        super(AI, self).__init__(tag, name)
        self.board = board
        self.smartness = smartness
        self.smartness_increase = G('smartness-increase', 'ai')
        self.board.setSmartness(self.smartness)
        self.board.setGoal(G('initial-goal', 'ai'))
        self.goals = []

    def addedToWorld(self, world):
        """Added to the world"""
        super(AI, self).addedToWorld(world)
        #
        self.manager = world.findActorByName('behaviours')
        self.goal_changer = self.manager.assignBehaviour(self, 
            serge.blocks.behaviours.TimedCallback(self.getGoalChangeInterval(), self.goalChange), 'goal-changer')
            
    def getGoalChangeInterval(self):
        """Return the goal change interval"""
        return random.randrange(*G('goal-change-range', 'ai'))*1000.0
    
    def goalChange(self, world, actor, interval):
        """Change the goal"""
        if not self.goals:
            self.goals = self.board.getPossibleGoals()
            random.shuffle(self.goals)
            #
            # If we can, try to avoid using the same goal as last time
            if len(self.goals) > 1 and self.goals[0] == self.board.getGoal():
                self.goals.pop(0)
        new_goal = self.goals.pop(0)
        self.board.setGoal(new_goal)
        self.goal_changer._behaviour.interval = self.getGoalChangeInterval()
        #
        self.smartness += self.smartness_increase
        self.board.setSmartness(self.smartness)

